/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class MotifFrameBorder
extends AbstractBorder
implements UIResource {
    JComponent jcomp;
    Color frameHighlight;
    Color frameColor;
    Color frameShadow;
    public static final int BORDER_SIZE = 5;
    static Insets insets = new Insets(5, 5, 5, 5);

    public MotifFrameBorder(JComponent jComponent) {
        this.jcomp = jComponent;
    }

    public void setComponent(JComponent jComponent) {
        this.jcomp = jComponent;
    }

    public JComponent component() {
        return this.jcomp;
    }

    protected Color getFrameHighlight() {
        return this.frameHighlight;
    }

    protected Color getFrameColor() {
        return this.frameColor;
    }

    protected Color getFrameShadow() {
        return this.frameShadow;
    }

    public Insets getBorderInsets(Component component) {
        return insets;
    }

    protected boolean drawTopBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, 5);
        if (!graphics.getClipBounds().intersects(rectangle)) {
            return false;
        }
        int n5 = n3 - 1;
        int n6 = 4;
        graphics.setColor(this.frameColor);
        graphics.drawLine(n, n2 + 2, n5 - 2, n2 + 2);
        graphics.drawLine(n, n2 + 3, n5 - 2, n2 + 3);
        graphics.drawLine(n, n2 + 4, n5 - 2, n2 + 4);
        graphics.setColor(this.frameHighlight);
        graphics.drawLine(n, n2, n5, n2);
        graphics.drawLine(n, n2 + 1, n5, n2 + 1);
        graphics.drawLine(n, n2 + 2, n, n2 + 4);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 4);
        graphics.setColor(this.frameShadow);
        graphics.drawLine(n + 4, n2 + 4, n5 - 4, n2 + 4);
        graphics.drawLine(n5, n2 + 1, n5, n6);
        graphics.drawLine(n5 - 1, n2 + 2, n5 - 1, n6);
        return true;
    }

    protected boolean drawLeftBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(0, 0, this.getBorderInsets((Component)component).left, n4);
        if (!graphics.getClipBounds().intersects(rectangle)) {
            return false;
        }
        int n5 = 5;
        graphics.setColor(this.frameHighlight);
        graphics.drawLine(n, n5, n, n4 - 1);
        graphics.drawLine(n + 1, n5, n + 1, n4 - 2);
        graphics.setColor(this.frameColor);
        graphics.fillRect(n + 2, n5, n + 2, n4 - 3);
        graphics.setColor(this.frameShadow);
        graphics.drawLine(n + 4, n5, n + 4, n4 - 5);
        return true;
    }

    protected boolean drawRightBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n3 - this.getBorderInsets((Component)component).right, 0, this.getBorderInsets((Component)component).right, n4);
        if (!graphics.getClipBounds().intersects(rectangle)) {
            return false;
        }
        int n5 = n3 - this.getBorderInsets((Component)component).right;
        int n6 = 5;
        graphics.setColor(this.frameColor);
        graphics.fillRect(n5 + 1, n6, 2, n4 - 1);
        graphics.setColor(this.frameShadow);
        graphics.fillRect(n5 + 3, n6, 2, n4 - 1);
        graphics.setColor(this.frameHighlight);
        graphics.drawLine(n5, n6, n5, n4 - 1);
        return true;
    }

    protected boolean drawBottomBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(0, n4 - this.getBorderInsets((Component)component).bottom, n3, this.getBorderInsets((Component)component).bottom);
        if (!graphics.getClipBounds().intersects(rectangle)) {
            return false;
        }
        int n5 = n4 - this.getBorderInsets((Component)component).bottom;
        graphics.setColor(this.frameShadow);
        graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n + 2, n4 - 2, n3 - 2, n4 - 2);
        graphics.setColor(this.frameColor);
        graphics.fillRect(n + 2, n5 + 1, n3 - 4, 2);
        graphics.setColor(this.frameHighlight);
        graphics.drawLine(n + 5, n5, n3 - 5, n5);
        return true;
    }

    protected boolean isActiveFrame() {
        return this.jcomp.hasFocus();
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.frameColor = this.isActiveFrame() ? UIManager.getColor((Object)"activeCaptionBorder") : UIManager.getColor((Object)"inactiveCaptionBorder");
        this.frameHighlight = this.frameColor.brighter();
        this.frameShadow = this.frameColor.darker().darker();
        this.drawTopBorder(component, graphics, n, n2, n3, n4);
        this.drawLeftBorder(component, graphics, n, n2, n3, n4);
        this.drawRightBorder(component, graphics, n, n2, n3, n4);
        this.drawBottomBorder(component, graphics, n, n2, n3, n4);
    }
}

